﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Web.Business.App;
using Soneta.Web.Business.Kadry;
using System.Collections.Generic;

namespace ASP {

    public partial class Pracownicy_Lista_Skrocona : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_OkresAll = "(wszystko)";
        public string Str_Mlodocianych = "pracowników młodocianych";
        public string Str_Pracownikow = "pracowników etatowych";
        public string Str_Wszystkich = "wszystkich pracowników";
        public string Str_Zatrudnionych = "Zatrudnionych w okresie";
        public string Str_Przyjetych = "Przyjętych do pracy w okresie";
        public string Str_Zwolnionych = "Zwolnionych z pracy w okresie";

        //Wspólny kod dla pracownicy - ewidencja, lista skrócona i lista pełna    
        [DefaultWidth(20)]
        public enum Filtr {
            Wszyscy,
            Pracownicy,
            PracownicyMłodociani
        }

        [DefaultWidth(20)]
        public enum Zakres {
            Wszyscy,
            Przyjęci,
            Zwolnieni
        }

        public class PrnParams : Soneta.Business.ContextBase {

            public PrnParams(Context context)
                : base(context) {
            }

            Filtr filtr = Filtr.Pracownicy;
            [Priority(1)]
			[Caption("Filtr")]
            public Filtr Filtr {
                get { return filtr; }
                set {
                    filtr = value;
                    OnChanged(EventArgs.Empty);
                }
            }
            Zakres zakres;
            [Priority(2)]
			[Caption("Zakres")]
            public Zakres Zakres {
                get { return zakres; }
                set {
                    zakres = value;
                    OnChanged(EventArgs.Empty);
                }
            }
            bool przedluzenia = true;
            [Priority(3)]
            [Caption("Uwzgl. przedłużenia")]
            public bool Przedluzenia {
                get { return przedluzenia; }
                set {
                    przedluzenia = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            public bool Test(PracHistoria historia, FromTo okres) {
                bool bb = true;
                if (Filtr != Filtr.Wszyscy || Zakres != Zakres.Wszyscy) {
                    switch (Zakres) {
                        case Zakres.Przyjęci:
                            FromTo zatr1 = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                            bb &= okres.Contains(zatr1.From);
                            break;
                        case Zakres.Zwolnieni:
                            FromTo zatr2 = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                            bb &= okres.Contains(zatr2.To);
                            break;
                    }
                    switch (Filtr) {
                        case Filtr.Pracownicy:
                            bb &= !Młodociany(historia.Etat.RodzajZatrudnienia);
                            break;
                        case Filtr.PracownicyMłodociani:
                            bb &= Młodociany(historia.Etat.RodzajZatrudnienia);
                            break;
                    }
                }
                return bb;
            }

            static bool Młodociany(RodzajZatrudnienia rodzaj) {
                switch (rodzaj) {
                    case RodzajZatrudnienia.Uczeń1Klasy:
                    case RodzajZatrudnienia.Uczeń2Klasy:
                    case RodzajZatrudnienia.Uczeń3Klasy:
                    case RodzajZatrudnienia.MłodocianyPrzyuczany:
                        return true;
                    default:
                        return false;
                }
            }
        }

        PrnParams pars;
        [Soneta.Business.Context(Required = true)]
        public PrnParams Params {
            set { pars = value; }
        }

		OkresContext okresContext;
		[Soneta.Business.Context(Required = true)]
		public OkresContext OkresContext {
			set { okresContext = value; }
		}
	
        protected void dc_ContextLoad(object sender, EventArgs e) {
            FromTo okres = okresContext.Okres;
            Date data = okresContext.Aktualny;

            ReportHeader1["OKRES"] = (okres != FromTo.All) ? okres.ToString() : Str_OkresAll;

            switch (pars.Zakres) {
				case Zakres.Przyjęci:
					ReportHeader1["CO"] = Str_Przyjetych;
					break;
				case Zakres.Zwolnieni:
					ReportHeader1["CO"] = Str_Zwolnionych;
					break;
				default:
					ReportHeader1["CO"] = Str_Zatrudnionych;
					break;
			}

			switch (pars.Filtr) {
				case Filtr.Pracownicy:
					ReportHeader1["KTO"] = Str_Pracownikow;
					break;
				case Filtr.PracownicyMłodociani:
					ReportHeader1["KTO"] = Str_Mlodocianych;
					break;
				default:
					ReportHeader1["KTO"] = Str_Wszystkich;
					break;
			}

			// Odczytanie listy pracowników podległych z kontekstu
			Row[] rows = getRows();

			ArrayList result = new ArrayList();
            foreach (Pracownik prac in rows) {
                PracHistoria ph = prac[data];
                if (pars.Test(ph, okres))
                    result.Add(ph);
            }
			Grid1.DataSource = result;
        }

        protected void Grid1_BeforeRow(Object sender, Soneta.Web.RowEventArgs args) {
            PracHistoria ph = (PracHistoria)args.Row;
            if (ph.ImieDrugie != "")
                imiona.EditValue = ph.Imie + ", " + ph.ImieDrugie;
            else
                imiona.EditValue = ph.Imie;
			dataZatrudnienia.EditValue = ph.Etat.OkresZatrudnienia.ToString();
        }

		private Row[] getRows() {
            IWebUser wu = dc.Context.Login.WebUserOperatingInstance;
            if (wu == null)
                return (Row[])dc[typeof(Row[])];

            List<Pracownik> list = new List<Pracownik>();
            Pracownik[] result = null;

            PodwladniKalkulator kalkPodwladni = new PodwladniKalkulator(dc.Context, wu.Host.ID);
            KadryModule module = KadryModule.GetInstance(dc);
            Soneta.Business.View view = module.Pracownicy.WgNazwiska.CreateView();
            if (pars.Filtr != Filtr.Wszyscy) {
                // Warunek dla Etat
                RowCondition rcEtat = kalkPodwladni.FiltrEtatu(okresContext.Okres, null);
                // Pracownicy, Pracownicy młodociani (etat, umowa)
                view.Condition &= rcEtat;
                // Warunek dla Niezatrudnionych
                kalkPodwladni.UwzgledniajNiezatrudnionych = false;
            }
            else {
                // Warunek dla Niezatrudnionych
                kalkPodwladni.UwzgledniajNiezatrudnionych = true;
            }
            // Uwzględnij podwładnych
            IWebUser wo = dc.Context.Login.WebUserInstance;
            view.Condition &= kalkPodwladni.PrzeliczFiltr(wu==wo);
            view.ForceAllRows();
            foreach (Pracownik prac in view)
                list.Add(prac);
            result = list.ToArray();

            return result;
        }
    }
}
